function Widget() {
    const ReadSelectionCharAmountSelections = [1, 10, 15, 20, 30, 50, 100, 200, 300, 400, 500];
    let self = this;
    self.injectWidget = injectWidget;
    self.injectImmersiveReader = injectImmersiveReader;
    self.injectSD = injectSD;
    self.injectQuickStart = injectQuickStart;
    self.setWidgetUI = setWidgetUI;
    self.setWidgetSetting = setWidgetSetting;
    self.addQuickStartBlackList = addQuickStartBlackList;
    self.removeQuickStartBlackList = removeQuickStartBlackList;
    self.addMostListenedWebsite = addMostListenedWebsite;
    self.defaultSettings = {
        isVisible: false,
        mode: 'min',
        readerState: 'init',
        voiceType: 'prem',
        speed: 0,
        volume: 0.75,
        freeVoice: null,
        readIcon: true,
        beHighlighted: [],
        isAutoScroll: true,
        isCC: false,
        isQuickStartWebpage: true,
        isQuickStartGoogleDocs: true,
        isQuickStartShowFullText: true,
        quickStartBlackList: {},
        mostListenedWebsites: {},
        isDyslexic: false,
        isClickToRead: true,
        isDarkTheme: false,
        isAutoSelectVoice: false,
        preferredVoicesByLang: {},
        prevVoiceTypeBeforeAutoSelectsFree: '',
        showReadSelectionToPageEndOption: true,
        readSelectionOption: 'selection',
        highlightColour: 'light',
        userInfo: {licNum: 0, licCode: '0', license: '0', pwLicCode: '0', pwLicNum: '0', email: 'user@naturalreaders.com'},
        loggedIn: 0,
        LimitedReadSelectionOn: false,
        LimitedReadSelectionCharAmount: 20,
        backwardStep: 0,
        forwardStep: 0,
        backwardSkipNumber: [1, 2],
        forwardSkipNumber: [2, 4],
        returnNormalSkipTime: 2000,
        isMaxModeOpenedBefore: false,
        isImmersiveTextSpacing: false,
        immersiveTextSize: 1
    };
    self.settings = self.defaultSettings;
    self.isAsyncFunction = isAsyncFunction;
    self.asyncFunctions = ['getWidgetSettings'];
    self.getWidgetSettings = getWidgetSettings;
    function init() {
        chrome.runtime.onMessage.addListener(function(request, sender, sendResponse) {
            if (self[request['fn']]) {
                self[request.fn](request, sender, sendResponse);
                if (self.isAsyncFunction(request.fn)) {
                    return true;
                }
            } else if (request.message === 'injectImmersiveReader') {
                injectImmersiveReader(sender.tab.id);
            }
        });
        initSettings();
    }
    function initSettings() {
        chrome.storage.sync.get(null, (result) => {
            if (chrome.runtime.lastError) {
            }
            self.settings.mode = result && result.mode ? result.mode : 'min';
            self.settings.voiceType = result && result.voiceType ? result.voiceType : 'prem';
            self.settings.freeVoice = result && result.freeVoice ? result.freeVoice : voices.defaultFreeVoice;
            self.settings.premVoice = result && result.premVoice ? result.premVoice : voices.defaultPremVoice;
            self.settings.plusVoice = result && result.plusVoice ? result.plusVoice : voices.defaultPlusVoice;
            self.settings.preset1Voice = result && result.preset1Voice ? result.preset1Voice : voices.defaultPremVoice;
            self.settings.preset2Voice = result && result.preset2Voice ? result.preset2Voice : voices.defaultPremVoice;
            self.settings.beHighlighted = result && result.beHighlighted ? result.beHighlighted : ['sentence', 'word'];
            self.settings.highlightColour = result && result.highlightColour ? result.highlightColour : 'light';
            self.settings.readIcon = result && result.readIcon != null ? result.readIcon : true;
            self.settings.isAutoScroll = result && 'isAutoScroll' in result ? result.isAutoScroll : true;
            self.settings.isCC = result && 'isCC' in result ? result.isCC : false;
            self.settings.isQuickStartWebpage = result && 'isQuickStartWebpage' in result ? result.isQuickStartWebpage : true;
            self.settings.isQuickStartGoogleDocs = result && 'isQuickStartGoogleDocs' in result ? result.isQuickStartGoogleDocs : true;
            self.settings.isQuickStartShowFullText = result && 'isQuickStartShowFullText' in result ? result.isQuickStartShowFullText : true;
            self.settings.quickStartBlackList = result && 'quickStartBlackList' in result ? result.quickStartBlackList : {};
            self.settings.mostListenedWebsites = result && 'mostListenedWebsites' in result ? result.mostListenedWebsites : {};
            self.settings.isDyslexic = result && 'isDyslexic' in result ? result.isDyslexic : false;
            self.settings.isClickToRead = result && 'isClickToRead' in result ? result.isClickToRead : true;
            self.settings.isDarkTheme = result && 'isDarkTheme' in result ? result.isDarkTheme : false;
            self.settings.isAutoSelectVoice = result && 'isAutoSelectVoice' in result ? result.isAutoSelectVoice : false;
            self.settings.preferredVoicesByLang = result && 'preferredVoicesByLang' in result ? result.preferredVoicesByLang : voices.preferredVoicesByLang;
            voices.preferredVoicesByLang = self.settings.preferredVoicesByLang;
            self.settings.prevVoiceTypeBeforeAutoSelectsFree = result && 'prevVoiceTypeBeforeAutoSelectsFree' in result ? result.prevVoiceTypeBeforeAutoSelectsFree : '';
            self.settings.readSelectionOption = result && result.readSelectionOption ? result.readSelectionOption : 'selection';
            self.settings.showReadSelectionToPageEndOption = result && result.showReadSelectionToPageEndOption != null ? result.showReadSelectionToPageEndOption : true;
            self.settings.LimitedReadSelectionOn = result && result.LimitedReadSelectionOn != null ? result.LimitedReadSelectionOn : true;
            self.settings.LimitedReadSelectionCharAmount = result && result.LimitedReadSelectionCharAmount && ReadSelectionCharAmountSelections.indexOf(parseInt(result.LimitedReadSelectionCharAmount)) > -1 ? result.LimitedReadSelectionCharAmount : 20;
            self.settings.speed = result && result.speed ? result.speed : 0;
            self.settings.volume = result && 'volume' in result ? result.volume : 0.75;
            self.settings.userInfo = result && result.userInfo ? result.userInfo : {licNum: 0, licCode: '0', license: '0', pwLicCode: '0', pwLicNum: '0', email: 'user@naturalreaders.com'};
            self.settings.loggedIn = result && 'loggedIn' in result ? result.loggedIn : 0;
            self.settings.backwardStep = self.defaultSettings.backwardStep;
            self.settings.forwardStep = self.defaultSettings.forwardStep;
            self.settings.backwardSkipNumber = result && result.backwardSkipNumber ? result.backwardSkipNumber : self.defaultSettings.backwardSkipNumber;
            self.settings.forwardSkipNumber = result && result.forwardSkipNumber ? result.forwardSkipNumber : self.defaultSettings.forwardSkipNumber;
            self.settings.returnNormalSkipTime = result && result.returnNormalSkipTime ? result.returnNormalSkipTime : self.defaultSettings.returnNormalSkipTime;
            self.settings.isMaxModeOpenedBefore = result && 'isMaxModeOpenedBefore' in result ? result.isMaxModeOpenedBefore : false;
            self.settings.isImmersiveTextSpacing = result && 'isImmersiveTextSpacing' in result ? result.isImmersiveTextSpacing : false;
            self.settings.immersiveTextSize = result && 'immersiveTextSize' in result ? result.immersiveTextSize : 1;
        });
    }
    function isAsyncFunction(fn) {
        if (self.asyncFunctions.includes(fn)) {
            return true;
        } else {
            return false;
        }
    }
    function injectWidget(tabId, docType, toShow, toStopReading = false) {
        return scriptInjector.canExecuteScript()
            .then(() => {
                return pdfDoc.isOnlinePdf()
            })
            .then((res) => {
                return new Promise((resolve) => {
                    if (!res) {
                        if (toStopReading && reader.beingReadTabId > 0 && tabId !== reader.beingReadTabId) {
                            reader.stop();
                        }
                        chrome.tabs.sendMessage(tabId, {fn: "getHasWidget"}, function(hasWidget) {
                            if (chrome.runtime.lastError) {
                                return scriptInjector.executeScriptsForTextProcessor(tabId, docType)
                                    .then(() => {
                                        chrome.tabs.executeScript(tabId, {file: "injected/nr-ext-widget/nr-ext-widget.js"}, function() {
                                            if (chrome.runtime.lastError) {
                                            }
                                            reader.beingReadTabId = tabId;
                                            chrome.tabs.sendMessage(tabId, {message: "injectWidget", showWelcome: extension.showWelcome}, function(res) {
                                                if (chrome.runtime.lastError) {
                                                }
                                                resolve();
                                            });
                                            injectSD(tabId, docType);
                                        });
                                    });
                            }
                            if (hasWidget) {
                                reader.beingReadTabId = tabId;
                                chrome.tabs.sendMessage(tabId, {fn: "toggleWidget", toShow: toShow, tabId: tabId, beingReadTabId: reader.beingReadTabId, activeTabId: extension.activeTabId}, () => void chrome.runtime.lastError);
                                resolve();
                            }
                        });
                    } else {
                        resolve();
                    }
                });
            })
            .catch((err) => {
            });
    }
    function injectSD(tabId, docType) {
        chrome.tabs.sendMessage(tabId, {fn: "getHasIcon"}, function(hasIcon) {
            if (chrome.runtime.lastError) {
                injectSDHelper(tabId, docType);
            } else {
                if (!hasIcon) {
                    injectSDHelper(tabId, docType);
                }
            }
        });
    }
    function injectQuickStart(tabID, docType) {
        if ((docType === 'html' && self.settings['isQuickStartWebpage']) || (docType === 'google doc' && self.settings['isQuickStartGoogleDocs'])) {
            chrome.tabs.executeScript(tabID, {
                code: "JSON.stringify({origin: location.origin, href:location.href})"
            }, function(res) {
                if (chrome.runtime.lastError) { }
                const location = JSON.parse(res[0]);
                if (!(location.origin in self.settings.quickStartBlackList) && location.href !== 'https://www.naturalreaders.com/ext/' && !(location.href).includes('naturalreaders.com/online/') && (location.origin in self.settings.mostListenedWebsites)) {
                    chrome.tabs.sendMessage(tabID, {fn: "getHasQuickStart"}, function(hasQuickStart) {
                        if (!(origin in self.settings.quickStartBlackList)) {
                            chrome.tabs.executeScript(tabID, {
                                code: 'var docType = ' + JSON.stringify(docType) + '; var isQuickStartShowFullText = ' + JSON.stringify(widget.settings.isQuickStartShowFullText)
                            }, () => void chrome.runtime.lastError);
                            if (chrome.runtime.lastError) {
                                return scriptInjector.executeScriptsForQuickStart(tabID, docType);
                            } else {
                                if (!hasQuickStart) {
                                    return scriptInjector.executeScriptsForQuickStart(tabID, docType);
                                }
                            }
                        }
                    });
                }
            });
        }
    }
    function injectSDHelper(tabId, docType) {
        chrome.tabs.executeScript(tabId, {file: "assets/js/jquery-3.6.0.min.js"}, () => {
            if (chrome.runtime.lastError) {
            }
            chrome.tabs.executeScript(tabId, {file: "injected/nr-ext-dom/nr-ext-text-processor/nr-ext-text-processor.js"}, () => {
                if (chrome.runtime.lastError) {
                }
                if (docType === 'google doc') {
                    chrome.tabs.executeScript(tabId, {file: "injected/nr-ext-dom/nr-ext-text-processor/google-doc-utils.js"}, () => {
                        if (chrome.runtime.lastError) {
                        }
                        chrome.tabs.executeScript(tabId, {file: "injected/nr-ext-dom/nr-ext-dom-detector.js"}, () => {
                            if (chrome.runtime.lastError) {
                            }
                            chrome.tabs.sendMessage(tabId, {
                                message: "injectSD",
                                value: {
                                    'iconState': self.settings.readIcon,
                                    'LimitedReadSelectionOn': self.settings.LimitedReadSelectionOn,
                                    'LimitedReadSelectionCharAmount': self.settings.LimitedReadSelectionCharAmount
                                }
                            }, () => void chrome.runtime.lastError);
                        })
                    });
                } else {
                    chrome.tabs.executeScript(tabId, {file: "injected/nr-ext-dom/nr-ext-dom-detector.js"}, () => {
                        if (chrome.runtime.lastError) {
                        }
                        chrome.tabs.sendMessage(tabId, {
                            message: "injectSD",
                            value: {
                                'iconState': self.settings.readIcon,
                                'LimitedReadSelectionOn': self.settings.LimitedReadSelectionOn,
                                'LimitedReadSelectionCharAmount': self.settings.LimitedReadSelectionCharAmount
                            }
                        }, () => void chrome.runtime.lastError);
                    })
                }
            });
        });
    }
    function injectImmersiveReader(tabId) {
        return new Promise((resolve) => {
            chrome.tabs.sendMessage(tabId, {fn: "getHasImmersiveReader"}, async function(hasImmersiveReader) {
                if (chrome.runtime.lastError) {
                    await injectImmersiveReaderHelper(tabId);
                    resolve();
                } else {
                    if (!hasImmersiveReader) {
                        await injectImmersiveReaderHelper(tabId);
                        resolve();
                    } else {
                        resolve();
                    }
                }
            });
        })
            .catch(err => {
            });
    }
    function injectImmersiveReaderHelper(tabId) {
        return new Promise((resolve) => {
            chrome.tabs.executeScript(tabId, {file: "injected/nr-ext-immersive-reader/nr-ext-immersive-reader.js"}, () => {
                if (chrome.runtime.lastError) {
                    resolve();
                }
                chrome.tabs.sendMessage(tabId, {
                    fn: "injectImmersiveReader",
                    tabId: tabId
                }, function(res) {
                    if (chrome.runtime.lastError) {
                        resolve();
                    }
                    resolve();
                });
            });
        })
            .catch(err => {
            });
    }
    function setWidgetUI(tabId) {
        if (tabId) {
            chrome.tabs.sendMessage(tabId, {fn: "getHasWidget"}, function(hasWidget) {
                if (chrome.runtime.lastError) {
                }
                if (hasWidget) {
                    chrome.tabs.sendMessage(tabId, {fn: "setWidgetUI"}, () => void chrome.runtime.lastError);
                }
            });
        }
    }
    function setWidgetSetting(request, sender, sendResponse) {
        let tabId = reader.beingReadTabId ? reader.beingReadTabId : extension.activeTabId;
        if (request.key === 'voiceType' && request.value !== self.settings.voiceType) {
            reader.setTts(request.value);
            reader.replay();
        } else if ((request.key == 'freeVoice' || request.key == 'premVoice' || request.key == 'plusVoice')) {
            if (!request.isAutoSelected) {
                voices.rememberPreferredVoiceByLang(request.key.split('Voice')[0], request.value);
            }
            if (request.value !== self.settings[request.key]) {
                reader.setTts(self.settings.voiceType);
                reader.replay();
            }
        } else if (request.key === 'speed' && request.value !== self.settings.speed) {
            reader.replay();
        } else if (request.key === 'volume' && request.value !== self.settings.volume) {
            reader.replay();
        } else if (request.key === 'beHighlighted') {
            chrome.tabs.sendMessage(tabId, {message: 'beHighlightedOnChange', beHighlighted: request.value, highlightColour: self.settings.highlightColour}, () => void chrome.runtime.lastError);
        } else if (request.key === 'highlightColour') {
            chrome.tabs.sendMessage(tabId, {message: 'highlightColourOnChange', highlightColour: request.value, oldHighlightColour: self.settings.highlightColour, beHighlighted: self.settings.beHighlighted, readerState: self.settings.readerState}, () => void chrome.runtime.lastError);
        } else if (request.key === 'isAutoScroll') {
            chrome.tabs.sendMessage(tabId, {message: 'isAutoScrollOnChange', isAutoScroll: request.value}, () => void chrome.runtime.lastError);
        } else if (request.key === 'LimitedReadSelectionCharAmount') {
            chrome.tabs.sendMessage(tabId, {message: 'setLimit', value: request.value}, () => void chrome.runtime.lastError)
        } else if (request.key === 'isVisible') {
            chrome.tabs.sendMessage(tabId, {message: 'isVisibleOnChange', isVisible: request.value, mode: self.settings.mode}, () => void chrome.runtime.lastError);
        }
        self.settings[request.key] = request.value;
        let obj = {};
        obj[request.key] = request.value;
        storage.set(obj);
        if (request.toPlay) {
            reader.play();
        }
        //
    }
    function addQuickStartBlackList(request, sender, sendResponse) {
        self.settings.quickStartBlackList[sender.origin] = true;
        const obj = {};
        obj['quickStartBlackList'] = self.settings.quickStartBlackList;
        storage.set(obj);
    }
    function removeQuickStartBlackList(request, sender, sendResponse) {
        delete self.settings.quickStartBlackList[sender.origin];
        const obj = {};
        obj['quickStartBlackList'] = self.settings.quickStartBlackList;
        storage.set(obj);
    }
    function addMostListenedWebsite(request, sender, sendResponse) {
        const origin = request.origin;
        if (origin in self.settings.mostListenedWebsites) {
            self.settings.mostListenedWebsites[origin].time = Date.now();
            self.settings.mostListenedWebsites[origin].num = self.settings.mostListenedWebsites[origin].num + 1;
        } else {
            self.settings.mostListenedWebsites[origin] = {time: Date.now(), num: 1};
        }
        const keys = Object.keys(self.settings.mostListenedWebsites);
        if (keys.length > 10) {
            const array = [];
            for (let i = 0; i < keys.length; i++) {
                const val = self.settings.mostListenedWebsites[keys[i]];
                array.push([keys[i], val.num, val.time]);
            }
            array.sort(function(w1, w2) {
                return w1[1] - w2[1] || w1[2] - w2[2];
            });
            delete self.settings.mostListenedWebsites[array[0][0]];
        }
    }
    function getWidgetSettings(request, sender, sendResponse) {
        if (request.key) {
            sendResponse(self.settings[request.key]);
        } else {
            sendResponse(self.settings);
        }
    }
    init();
}
const widget = new Widget();
